use <Templates\bubbleEnclosure.scad>
use <Templates/bubbleEnclosure.scad>

XDim = 23;
YDim = 50;
ZDim = 25;
thickness = 1.8;
screwRadius = 2.0;

circularCordRadius = 2.2;
flatWireWidth = 4;
flatWireHeight = 1.25;

$fn = 100;

holeXTranslate = (XDim + thickness)/2;
holeYTranslate = (YDim + thickness)/2;
holeZTranslate = (ZDim) + thickness;

difference(){
    bubbleEnclosure(XDim, YDim, ZDim, thickness, screwRadius);
    translate([0, holeYTranslate, holeZTranslate-circularCordRadius]){
        cordHole();
    }
    translate([0, flatWireWidth, holeZTranslate - flatWireHeight/2]){
        cube([XDim + thickness*3, flatWireWidth, flatWireHeight+0.01], center = true);
    }
    translate([0, -flatWireWidth, holeZTranslate - flatWireHeight/2]){
        cube([XDim + thickness*3, flatWireWidth, flatWireHeight+0.01], center = true);
    }
}

module cordHole(){
    rotate([90,0,0]){
        cylinder(thickness*2, circularCordRadius, circularCordRadius, center = true);
        translate([0,circularCordRadius,0]){
            cube([circularCordRadius*2, circularCordRadius*2, thickness*2], center = true);
        }
    }
}